/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.network.PacketSimpleMessage;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.EntitiesTFC;
import net.dries007.tfc.objects.entity.ai.EntityAITamableAvoidPlayer;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ParametersAreNonnullByDefault
public class EntityWolfTFC
extends EntityWolf
implements IAnimalTFC,
ILivestock {
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityWolfTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityWolfTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FAMILIARITY = EntityDataManager.func_187226_a(EntityWolfTFC.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> FERTILIZED = EntityDataManager.func_187226_a(EntityWolfTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Long> PREGNANT_TIME = EntityDataManager.func_187226_a(EntityWolfTFC.class, EntitiesTFC.getLongDataSerializer());
    private long lastFed;
    private long lastFDecay;
    private long matingTime;
    private long lastDeath;

    public EntityWolfTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(ConfigTFC.Animals.WOLF.adulthood, ConfigTFC.Animals.WOLF.elder));
    }

    public EntityWolfTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
        this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
        this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
        this.setFertilized(false);
        this.setPregnantTime(-1L);
        this.func_70105_a(0.6f, 0.85f);
        this.func_70903_f(false);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.PLAINS && biomeType != BiomeHelper.BiomeType.TAIGA)) {
            return ConfigTFC.Animals.WOLF.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 1;
    }

    @Override
    public int getMaxGroupSize() {
        return 5;
    }

    public void birthChildren() {
        int numberOfChildren = ConfigTFC.Animals.WOLF.babies;
        for (int i = 0; i < numberOfChildren; ++i) {
            EntityWolfTFC baby = new EntityWolfTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            UUID uuid = this.func_184753_b();
            if (uuid != null) {
                baby.func_184754_b(uuid);
                baby.func_70903_f(true);
            }
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.35f;
    }

    @Override
    public float getFamiliarity() {
        return ((Float)this.field_70180_af.func_187225_a(FAMILIARITY)).floatValue();
    }

    @Override
    public void setFamiliarity(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        }
        if (value > 1.0f) {
            value = 1.0f;
        }
        this.field_70180_af.func_187227_b(FAMILIARITY, (Object)Float.valueOf(value));
    }

    @Override
    public boolean isFertilized() {
        return (Boolean)this.field_70180_af.func_187225_a(FERTILIZED);
    }

    @Override
    public void setFertilized(boolean value) {
        this.field_70180_af.func_187227_b(FERTILIZED, (Object)value);
    }

    @Override
    public void onFertilized(IAnimalTFC male) {
        this.setPregnantTime(CalendarTFC.PLAYER_TIME.getTotalDays());
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.WOLF.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.WOLF.elder;
    }

    @Override
    public boolean isReadyToMate() {
        if (this.getAge() != IAnimalTFC.Age.ADULT || this.getFamiliarity() < 0.3f || this.isFertilized() || this.isHungry()) {
            return false;
        }
        return this.matingTime + 2000L <= CalendarTFC.PLAYER_TIME.getTicks();
    }

    @Override
    public boolean isHungry() {
        return this.lastFed < CalendarTFC.PLAYER_TIME.getTotalDays();
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    public long getPregnantTime() {
        return (Long)this.field_70180_af.func_187225_a(PREGNANT_TIME);
    }

    public void setPregnantTime(long pregnantTime) {
        this.field_70180_af.func_187227_b(PREGNANT_TIME, (Object)pregnantTime);
    }

    public long gestationDays() {
        return ConfigTFC.Animals.WOLF.gestation;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(10, new EntityAITamableAvoidPlayer<EntityWolfTFC>(this, 7.0f, 1.0, 1.5));
        super.func_184651_r();
        int priority = 1;
        for (String input : ConfigTFC.Animals.WOLF.huntCreatures) {
            Class entityClass;
            ResourceLocation key = new ResourceLocation(input);
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
            if (entityEntry == null || !EntityLivingBase.class.isAssignableFrom(entityClass = entityEntry.getEntityClass())) continue;
            this.field_70715_bh.func_75776_a(priority++, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, entityClass, false, ent -> true));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
        this.func_184212_Q().func_187214_a(FAMILIARITY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PREGNANT_TIME, (Object)-1L);
        this.func_184212_Q().func_187214_a(FERTILIZED, (Object)false);
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
        nbt.func_74772_a("fed", this.lastFed);
        nbt.func_74772_a("decay", this.lastFDecay);
        nbt.func_74757_a("fertilized", this.isFertilized());
        nbt.func_74772_a("mating", this.matingTime);
        nbt.func_74776_a("familiarity", this.getFamiliarity());
        nbt.func_74772_a("lastDeath", this.lastDeath);
        nbt.func_74772_a("pregnant", this.getPregnantTime());
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
        this.lastFed = nbt.func_74763_f("fed");
        this.lastFDecay = nbt.func_74763_f("decay");
        this.matingTime = nbt.func_74763_f("mating");
        this.setFertilized(nbt.func_74767_n("fertilized"));
        this.setFamiliarity(nbt.func_74760_g("familiarity"));
        this.lastDeath = nbt.func_74763_f("lastDeath");
        this.setPregnantTime(nbt.func_74763_f("pregnant"));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_WOLF;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (!this.field_70170_p.field_72995_K) {
            float familiarity;
            if (this.isFertilized() && CalendarTFC.PLAYER_TIME.getTotalDays() >= this.getPregnantTime() + this.gestationDays()) {
                this.birthChildren();
                this.setFertilized(false);
            }
            if (this.lastFDecay > -1L && this.lastFDecay + 1L < CalendarTFC.PLAYER_TIME.getTotalDays() && (familiarity = this.getFamiliarity()) < 0.3f) {
                familiarity = (float)((double)familiarity - 0.02 * (double)(CalendarTFC.PLAYER_TIME.getTotalDays() - this.lastFDecay));
                this.lastFDecay = CalendarTFC.PLAYER_TIME.getTotalDays();
                this.setFamiliarity(familiarity);
            }
            if (this.getGender() == IAnimalTFC.Gender.MALE && this.isReadyToMate()) {
                this.matingTime = CalendarTFC.PLAYER_TIME.getTicks();
                EntityAnimalTFC.findFemaleMate(this);
            }
            if (this.getAge() == IAnimalTFC.Age.OLD && this.lastDeath < CalendarTFC.PLAYER_TIME.getTotalDays()) {
                this.lastDeath = CalendarTFC.PLAYER_TIME.getTotalDays();
                Random random = new Random(this.field_96093_i.getMostSignificantBits() * CalendarTFC.PLAYER_TIME.getTotalDays());
                if (random.nextDouble() < ConfigTFC.Animals.WOLF.oldDeathChance) {
                    this.func_70106_y();
                }
            }
            if (this.getDaysToElderly() > 0 && this.getFamiliarity() < 0.1f && (float)(this.getDaysToElderly() + this.getDaysToAdulthood()) * 1.25f <= (float)(CalendarTFC.PLAYER_TIME.getTotalDays() - (long)this.getBirthDay())) {
                this.func_70106_y();
            }
        }
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b()) {
            if (itemstack.func_77973_b() == Items.field_151063_bx) {
                return super.func_184645_a(player, hand);
            }
            if (this.isFood(itemstack)) {
                if (!this.func_70919_bu() && player.func_70093_af() && this.getAdultFamiliarityCap() > 0.0f) {
                    IFood cap = (IFood)itemstack.getCapability(CapabilityFood.CAPABILITY, null);
                    if (cap != null && cap.isRotten()) {
                        return false;
                    }
                    if (this.isHungry()) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.lastFDecay = this.lastFed = CalendarTFC.PLAYER_TIME.getTotalDays();
                            this.func_175505_a(player, itemstack);
                            if (this.getAge() == IAnimalTFC.Age.CHILD || this.getFamiliarity() < this.getAdultFamiliarityCap()) {
                                float familiarity = this.getFamiliarity() + 0.06f;
                                if (this.getAge() != IAnimalTFC.Age.CHILD) {
                                    familiarity = Math.min(familiarity, this.getAdultFamiliarityCap());
                                }
                                this.setFamiliarity(familiarity);
                            }
                            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.AMBIENT, 1.0f, 1.0f);
                            TFCTriggers.FAMILIARIZATION_TRIGGER.trigger((EntityPlayerMP)player, this);
                        }
                        return true;
                    }
                    if (!this.func_70909_n() && this.getFamiliarity() >= 0.3f) {
                        if (!this.field_70170_p.field_72995_K) {
                            this.func_175505_a(player, itemstack);
                            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                                this.func_193101_c(player);
                                this.field_70699_by.func_75499_g();
                                this.func_70624_b(null);
                                this.field_70911_d.func_75270_a(true);
                                this.func_70908_e(true);
                                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                            } else {
                                this.func_70908_e(false);
                                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                            }
                        }
                        return true;
                    }
                    if (!this.field_70170_p.field_72995_K && this.isFertilized() && this.getType() == IAnimalTFC.Type.MAMMAL) {
                        TerraFirmaCraft.getNetwork().sendTo((IMessage)PacketSimpleMessage.translateMessage(PacketSimpleMessage.MessageCategory.ANIMAL, "tfc.tooltip.animal.mating.pregnant", this.getAnimalName()), (EntityPlayerMP)player);
                    }
                }
                return false;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    public EntityWolfTFC createChild(@Nonnull EntityAgeable other) {
        if (other != this && this.getGender() == IAnimalTFC.Gender.FEMALE && other instanceof IAnimalTFC) {
            this.setFertilized(true);
            this.func_70875_t();
            this.onFertilized((IAnimalTFC)other);
        } else if (other == this) {
            try {
                EntityWolfTFC baby = new EntityWolfTFC(this.field_70170_p);
                baby.setGender(IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()));
                baby.setBirthDay((int)CalendarTFC.PLAYER_TIME.getTotalDays());
                baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
                if (this.func_70909_n()) {
                    baby.func_184754_b(this.func_184753_b());
                    baby.func_70903_f(true);
                }
                return baby;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        EntityWolfTFC other = (EntityWolfTFC)otherAnimal;
        return this.getGender() != other.getGender() && this.func_70880_s() && other.func_70880_s();
    }
}

